/******************************************************************************/
/* E#21867 Anpassung neue Spezifikation Postcon  Data Matrix Code          */
/******************************************************************************/
DECLARE @lCodeRuleID INT
IF NOT EXISTS (SELECT * FROM CodeRule WHERE guidCodeRule = '2DB9C622-F4FA-492B-8A76-01DA1D575F9D') 
BEGIN
	INSERT INTO 
		CodeRule 
		(
			guidCodeRule, 
			fActive, 
			strMatch, 
			strDescription, 
			lOrder, 
			dtChanged, 
			dtCreated
		) 
	VALUES 
		(
			N'2DB9C622-F4FA-492B-8A76-01DA1D575F9D', 
			1, 
			N'^\s*PCNB\d{16}\d{5}\d{3}\d{1}\d{2}', 
			N'String has to begin with PCNB', 
			(SELECT MAX(lOrder) + 1 FROM CodeRule), 
			GETDATE(),
			GETDATE()
		)
	
	SET @lCodeRuleID = (SELECT SCOPE_IDENTITY())
	
	INSERT INTO 
		ParsingRule 
		(
			lCodeRuleID, 
			fActive, 
			lOrder, 
			strName, 
			strDescription, 
			strRule, 
			dtChanged, 
			dtCreated
		)
	VALUES 
		(
			@lCodeRuleID, 
			1, 
			0, 
			N'Postcon-Data Matrix Version B (alphanumerische Variante)', 
			N'Spezialparser Postcon-Data Matrix Version B (alphanumerische Variante)', 
			N'(?:^PCNB)(?<Alternativcode>\d{16})(?<PLZ>\d{5})(?<PARTNERID>\d{3})(?<DROPLOCATIONID>\d{1})(?<PRODUCTCODE>\d{2})(?<CUSTINFO>.*)', 
			GETDATE(),
			GETDATE()
		)

	UPDATE
		CodeRule
	SET
		lOrder = (SELECT MAX(lOrder) + 1 FROM CodeRule)
	WHERE
		guidCodeRule = '3A151BA0-DFB6-47EF-92C4-7CBF1657501E'
END

IF NOT EXISTS (SELECT * FROM CodeRule WHERE guidCodeRule = '5CD6840A-817A-422F-9900-8CE338AF92D9')
BEGIN
	INSERT INTO 
		CodeRule 
		(
			guidCodeRule, 
			fActive, 
			strMatch, 
			strDescription, 
			lOrder, 
			dtChanged, 
			dtCreated
		) 
	VALUES 
		(
			N'5CD6840A-817A-422F-9900-8CE338AF92D9', 
			1, 
			N'^\s*20142002\d{16}\d{5}\d{3}\d{1}\d{2}', 
			N'String has to begin with 20142002', 
			(SELECT MAX(lOrder) + 1 FROM CodeRule), 
			GETDATE(),
			GETDATE()
		)
	
	SET @lCodeRuleID = (SELECT SCOPE_IDENTITY())
	
	INSERT INTO 
		ParsingRule 
		(
			lCodeRuleID, 
			fActive, 
			lOrder, 
			strName, 
			strDescription, 
			strRule, 
			dtChanged, 
			dtCreated
		)
	VALUES 
		(
			@lCodeRuleID, 
			1, 
			0, 
			N'Postcon-Data Matrix Version B (numerische Variante)', 
			N'Spezialparser Postcon-Data Matrix Version B (numerische Variante)', 
			N'(?:^20142002)(?<Alternativcode>\d{16})(?<PLZ>\d{5})(?<PARTNERID>\d{3})(?<DROPLOCATIONID>\d{1})(?<PRODUKTCODE>\d{2})(?<CUSTINFO>.*)', 
			GETDATE(),
			GETDATE()
		)

	UPDATE
		CodeRule
	SET
		lOrder = (SELECT MAX(lOrder) + 1 FROM CodeRule)
	WHERE
		guidCodeRule = '3A151BA0-DFB6-47EF-92C4-7CBF1657501E'
END
GO